﻿#pragma   once

#include  "Resource.h"
#include  "Guids.hpp"
#include  <boost/smart_ptr.hpp>

#if       !defined(INCLUDED_SZ_FORWARD_DECLARATIONS)
#include  <szForwardDeclarations.hpp>
#endif // !defined(INCLUDED_SZ_FORWARD_DECLARATIONS)

class ArchiveVolumeInfo;

class ATL_NO_VTABLE CArchiveFolder :
  public CComObjectRootEx<CComSingleThreadModel>,
  public CComCoClass<CArchiveFolder, &CLSID_ArchiveFolder>,
  public IPersistFolder2,
  public IShellFolder2
{
public:
  CArchiveFolder();
  ~CArchiveFolder();

DECLARE_REGISTRY_RESOURCEID(IDR_ARCHIVEFOLDER)

DECLARE_NOT_AGGREGATABLE(CArchiveFolder)

BEGIN_COM_MAP(CArchiveFolder)
  COM_INTERFACE_ENTRY(IPersist)
  COM_INTERFACE_ENTRY(IPersistFolder)
  COM_INTERFACE_ENTRY(IPersistFolder2)
  COM_INTERFACE_ENTRY(IShellFolder)
  COM_INTERFACE_ENTRY(IShellFolder2)
END_COM_MAP()

  DECLARE_PROTECT_FINAL_CONSTRUCT()

  HRESULT FinalConstruct() { return S_OK; }
  void    FinalRelease() { }

public:

  // IPersist
  STDMETHODIMP GetClassID(__out CLSID *pClassID);
  // IPersistFolder   
  STDMETHODIMP Initialize(__in PCIDLIST_ABSOLUTE pidl);
  // IPersistFolder2
  STDMETHODIMP GetCurFolder(__out PIDLIST_ABSOLUTE *ppidl);

  // IShellFolder
  STDMETHODIMP BindToObject(__in PCUIDLIST_RELATIVE pidl, __in IBindCtx *pbc, __in REFIID riid, __out void **ppv);
  STDMETHODIMP BindToStorage(__in PCUIDLIST_RELATIVE pidl, __in IBindCtx *pbc, __in REFIID riid, __out void **ppv);
  STDMETHODIMP CompareIDs(__in LPARAM lParam, __in PCUIDLIST_RELATIVE pidl1, __in PCUIDLIST_RELATIVE pidl2);
  STDMETHODIMP CreateViewObject(__in HWND hwndOwner, __in REFIID riid, __out void **ppv);
  STDMETHODIMP EnumObjects(__in HWND hwnd, __in SHCONTF grfFlags, __out IEnumIDList **ppenumIDList);
  STDMETHODIMP GetAttributesOf(__in UINT cidl, __in PCUITEMID_CHILD_ARRAY apidl, __inout SFGAOF *rgfInOut);
  STDMETHODIMP GetDisplayNameOf(__in PCUITEMID_CHILD pidl, __in SHGDNF uFlags, __out STRRET *pName);
  STDMETHODIMP GetUIObjectOf(__in HWND hwndOwner, __in UINT cidl, __in PCUITEMID_CHILD_ARRAY apidl, __in REFIID riid, __reserved UINT *rgfReserved, __out void **ppv);
  STDMETHODIMP ParseDisplayName(__in HWND hwnd, __in IBindCtx *pbc, __in LPWSTR pszDisplayName, __out ULONG *pchEaten, __out PIDLIST_RELATIVE *ppidl, __inout ULONG *pdwAttributes);
  STDMETHODIMP SetNameOf(__in HWND hwnd, __in PCUITEMID_CHILD pidl, __in LPCWSTR pszName, __in SHGDNF uFlags, __out PITEMID_CHILD *ppidlOut);

  // IShellFolder2
  STDMETHODIMP GetDefaultSearchGUID(__out GUID *pguid);
  STDMETHODIMP EnumSearches(__out IEnumExtraSearch **ppenum);
  STDMETHODIMP GetDefaultColumn(__in DWORD dwRes, __out ULONG *pSort, __out ULONG *pDisplay);
  STDMETHODIMP GetDefaultColumnState(__in UINT iColumn, __out SHCOLSTATEF *pcsFlags);
  STDMETHODIMP GetDetailsEx(__in PCUITEMID_CHILD pidl, __in const SHCOLUMNID *pscid, __out VARIANT *pv);
  STDMETHODIMP GetDetailsOf(__in PCUITEMID_CHILD pidl, __in UINT iColumn, __out SHELLDETAILS *psd);
  STDMETHODIMP MapColumnToSCID(__in UINT iColumn, __out SHCOLUMNID *pscid);

private:
  HRESULT InitializeOnBind(CArchiveFolder *ancestor, const szstring &relativePath, PCIDLIST_RELATIVE relativePidl);
  void DelayOpen();

  PIDLIST_ABSOLUTE m_ThisPidl; // このフォルダのルート相対 PIDL
  PIDLIST_ABSOLUTE m_RootPidl; // ルート（アーカイブファイル）の PIDL
  szstring m_ThisPath;         // このフォルダのルート相対パス
  szstring m_RootPath;         // ルート（アーカイブファイル）のパス

  boost::shared_ptr<ArchiveVolumeInfo> m_VolumeInfo;
  szpp::StoredItemContainer           *m_Container;

};

OBJECT_ENTRY_AUTO(CLSID_ArchiveFolder, CArchiveFolder)
